/* ============ */
/* gapdefs.h	*/
/* ============ */
/* ==================================================================== */
/*       TYPEDEFS, #DEFINES AND PROTOTYPES FOR MAXIMUM OF T TEST	*/
/* ==================================================================== */
# if defined(__MAXTDEFS_H__)
#	/* Do Nothing */
# else
#	define	__MAXTDEFS_H__

# if !defined(__DEFCODES)

typedef	unsigned char		UCHAR;
typedef	unsigned int		UINT;

#define	FALSE	0
#define	TRUE	1
# endif

#define	MAX_SQNCE_LEN		100
#define	MIN_SQNCE_LEN		5
#define	MAX_NUM_SQNCE		1000
#define	MIN_NUM_SQNCE		200

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
typedef	struct	MaxtDataStru
    {
	UINT	NumSequences;	/* Number of Sequences to be Assessed	*/
	int	SequenceLen;	/* Length of Sequence to Get Max From	*/
	double	KSPos;		/* Kn+ Kolmogorov-Smirnov Statistic	*/
	double	KSNeg;		/* Kn- Kolmogorov-Smirnov Statistic	*/
	double	ProbKSPos;	/* Probability Associated with Kn+	*/
	double	ProbKSNeg;	/* Probability Associated with Kn-	*/
	long	TotNumGen;	/* Cumulative Random Variate Count	*/
	int	CallStatusOK;	/* 0 = FALSE, 1 = TRUE			*/
	int	(*RandFun) F((void));/* Addr. of Generating Function	*/
    }
	MAXT_DATA_STRU;

extern	void	ApplyKStoMaxOfT   F((struct MaxtDataStru *));
extern	void	SetMaxOfTControls F((struct MaxtDataStru *));

# undef F
/* INDENT ON */

# endif				/* <<< __MAXTDEFS_H__ >>> */
